use "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\full_data_10202016.dta", clear
merge 1:1 name date using "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\mve_assets.dta"

*** now we want to see relationship btwn mve/assets and vol 

*** let's graph relationship for each firm 
gen vol_100 = vol/100 
gen mve_vol_ratio = mve_div_assets/vol_100
su mve_vol_ratio

*** now our focus is on MVE/assets and CDS spread 
capture drop output_indicator
by year name, sort: egen vol_annual = mean(vol_100)
by year name, sort: egen mve_annual = mean(mve_div_assets)
by year name, sort: egen mve_vol_annual = mean(mve_vol_ratio)
by year name, sort: gen output_indicator = _n 

*** unfortunately we don't have CDS data prior to 2004. 
*** we want scatters by bank 
keep if output_indicator == 1 

label var vol_annual "Volatility"
label var mve_annual "MVE/A"
label var mve_vol_ratio "Ratio of MVE/Assets to Equity Volatility"

cd "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Tables"

*** same set of tables, but instead we want to do relative to market price
graph twoway (scatter mve_vol_ratio year) if (name == "baml" & year>1990), xtitle("") title("Bank of America") xlabel(,labsize(small)) 

graph export baml_vol_mve.png, replace 

graph twoway (scatter mve_vol_ratio year) if (name == "citi" & year>1990), xtitle("") title("Citigroup") xlabel(,labsize(small)) 

graph export citi_vol_mve.png, replace 

graph twoway (scatter mve_vol_ratio year) if (name == "ms" & year>1994), xtitle("") title("Morgan Stanley") xlabel(,labsize(small)) 

graph export ms_vol_mve.png, replace 

graph twoway (scatter mve_vol_ratio year) if (name == "gs" & year>1999), xtitle("") title("Goldman Sachs") xlabel(,labsize(small))  

graph export gs_vol_mve.png, replace 

graph twoway (scatter mve_vol_ratio year)  if (name == "wf" & year>1990), xtitle("") title("Wells Fargo") xlabel(,labsize(small))  

graph export wf_vol_mve.png, replace 

graph twoway (scatter mve_vol_ratio year) if (name == "jpm" & year>1990), xtitle("") title("JP Morgan") xlabel(,labsize(small)) 

graph export jpm_vol_mve.png, replace   

**** now let's graph on same graph 
graph twoway (line vol_annual year, yaxis(1) cmissing(no) ytitle("Volatility")) || (line mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/Assets", axis(2))) if (name == "baml" & year>1990), xtitle("") title("Bank of America") xlabel(,labsize(small)) 

graph export baml_vol_mve_sep.png, replace 

graph twoway (line vol_annual year, yaxis(1) cmissing(no) ytitle("Volatility")) || (line mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/Assets", axis(2))) if (name == "citi" & year>1990), xtitle("") title("Citigroup") xlabel(,labsize(small)) 

graph export citi_vol_mve_sep.png, replace 

graph twoway (line vol_annual year, yaxis(1) cmissing(no) ytitle("Volatility")) || (line mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/Assets", axis(2))) if (name == "ms" & year>1994), xtitle("") title("Morgan Stanley") xlabel(,labsize(small)) 

graph export ms_vol_mve_sep.png, replace 

graph twoway (line vol_annual year, yaxis(1) cmissing(no) ytitle("Volatility")) || (line mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/Assets", axis(2))) if (name == "gs" & year>1999), xtitle("") title("Goldman Sachs") xlabel(,labsize(small))  

graph export gs_vol_mve_sep.png, replace 

graph twoway (line vol_annual year, yaxis(1) cmissing(no) ytitle("Volatility")) || (line mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/Assets", axis(2)))  if (name == "wf" & year>1990), xtitle("") title("Wells Fargo") xlabel(,labsize(small))  

graph export wf_vol_mve_sep.png, replace 

graph twoway (line vol_annual year, yaxis(1) cmissing(no) ytitle("Volatility")) || (line mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/Assets", axis(2))) if (name == "jpm" & year>1990), xtitle("") title("JP Morgan") xlabel(,labsize(small)) 

graph export jpm_vol_mve_sep.png, replace   
